<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    
    include "../gUtil/GestoreUpload.php";
    include "../classi/Documento.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    
    include "include/controlloLogin.php";
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    $documento = new Documento($geecomDb, filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
    $documento->caricaDatiDalDatabase();
    
    /*
     * recupero l'ultima versione del documento perché devo generare l'icona di default (perché potrebbe cambiare rispetto alla 
     * versione originale del file)
     */
    $queryUltimaVersione = "SELECT * FROM geecD_versioniDocumento WHERE idDocumento = {$documento->getId()} ORDER BY id DESC LIMIT 1";
    $risUltimaVersione   = $geecomDb->eseguiQueryLettura($queryUltimaVersione);
    $datiUltimaVersione  = $risUltimaVersione->fetch_assoc();
    $dataUltimaModifica  = date("d/m/Y",strtotime($datiUltimaVersione["dataCreazione"]));
        
    $parametriRicerca    = array("idDocumento"=>$documento->getId(),"autore"=>$cerca);
    $parametri = array("tabella"=>"geecD_versioniDocumento", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
    $ricerca   = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"dettagliDocumento.php");
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
    <title>Geecom Doc - dettagli documento <?= $documento->getNome() ?></title>

  </head>
  <body>
    
    <header>
        <?php 
            include "include/barraSuperiore.php";
            
            include "include/header.php";
            
            include "include/barraMenu.php";
        ?>
    </header>
	  
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div class="row">
                <!-- Colonna principale -->
                <div class="col-12 py-4">
                    <div class="form-row">
                        <div class="col-md-4 col-lg-3 sticky-top-md align-self-start versione-corrente-file">
                            <div class="card card-body border-0 mb-4">
                                <div class="azioni">
                                    <button type="button" class="btn btn-light btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                     <i class="fas fa-cog"></i>
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="btnGroupDrop1">
                                        <a class="dropdown-item" href="#">Crea pagina condivisione</a>
                                        <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modalModificaDocumento">Modifica</a>
                                        <a class="dropdown-item text-danger" href="javascript:void" onclick="apriModalEliminaDocumento(<?= $documento->getId() ?>,'<?= filter_var($documento->getNome(),FILTER_SANITIZE_ADD_SLASHES) ?>')">Elimina</a>
                                    </div>
                                </div>
                                <div class="inner">
                                    <div class="">
                                        <?php 
                                            $datiFile = pathinfo($datiUltimaVersione["percorsoFile"]);
                                        ?>
                                        <i class="<?= iconaEstensione($datiFile["extension"]) ?> fa-2x d-block mb-2"></i>
                                        <h5 class="text-primary"><b><?= $documento->getNome() ?></b></h5>
                                    </div>
                                    <p class="mb-0">Ultima modifica il <?= $dataUltimaModifica ?></p>
                                    <small><?= $documento->getDescrizione() ?></small>
                                    <div>
                                        <?php 
                                            $queryEtichette = "SELECT e.* FROM geecD_associazioneEtichetteDocumenti AS ed JOIN geecD_etichette AS e ON ed.idEtichetta = e.id WHERE idDocumento = {$documento->getId()}";
                                            $risEtichette   = $geecomDb->eseguiQueryLettura($queryEtichette);
                                            while($etichetta = $risEtichette->fetch_assoc()) {
                                                ?>  
                                                <span class="badge badge-light"><?= $etichetta["nome"] ?></span>
                                                <?php
                                            }
                                        ?>
                                    </div>
                                    <a class="btn btn-primary btn-block mt-3" href="scaricaVersioneDocumento.php?idDocumento=<?= $documento->getId() ?>">Scarica versione corrente<i class="fas fa-download ml-2"></i></a>
                                </div>
                            </div>
                            
                            <form action="../controller/controllerDocumenti.php" id="frmFileUpload-00" class="dropzone singolo-file mb-3" method="post" enctype="multipart/form-data">
                                <div class="dz-message">
                                    <i class="fas fa-file-upload fa-2x mb-2"></i>
                                    <h5>Trascina o carica qui la nuova versione</h5>
                                </div>
                                <div class="fallback">
                                    <input name="file" type="file" />
                                </div>
                            </form>      
                        </div>
                        <div class="col-md-8 col-lg-9">
                            <div class="row">                        
                                <div class="col-lg-8 mb-4">
                                    <?php 
                                        if($status==200) {
                                            echo"<div class=\"col-12\">
                                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                                        Documento modificato
                                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                            <span aria-hidden=\"true\">&times;</span>
                                                        </button>
                                                    </div>
                                                </div>";
                                        }
                                        else if($status==200) {
                                            echo"<div class=\"col-12\">
                                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                                        Documento modificato
                                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                            <span aria-hidden=\"true\">&times;</span>
                                                        </button>
                                                    </div>
                                                </div>";
                                        }
                                    ?>

                                    <div class="card card-body border-0">
                                        <?php 
                                            $documento->stampaBreadcrumbDocumento();
                                        ?>

                                        <div class="table-responsive table-sm">
                                            <?php
                                                if(isset($_GET["pag"])) {
                                                    $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                                }
                                                else {
                                                    $ris = $ricerca->eseguiRicerca(1);
                                                }

                                                $colonne = array("ID","Autore","Dimensione MB","Numero download","Data caricamento","");
                                                $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                                $tabella->setTipo("normale");

                                                while($datiVersione = $ris->fetch_assoc()) {
                                                    $dataCreazione = date("d/m/Y H:i:s",strtotime($datiVersione["dataCreazione"]));
                                                    $azioni = array("scarica"=>"scaricaVersioneDocumento.php?idVersione={$datiVersione["id"]}","elimina"=>"eliminaVersione({$datiVersione["id"]},'{$datiVersione["id"]} - autore: {$datiVersione["autore"]}')");
                                                    $tabella->aggiungiNuovaRiga(array($datiVersione["id"],$datiVersione["autore"],$datiVersione["dimensione"],$datiVersione["numeroDownload"],$dataCreazione),$azioni);
                                                }
                                                $tabella->stampa("rigaVersione",0);
                                                $ricerca->stampaPaginazione(true,"dettagliDocumento.php");
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="chatbot">
                                        <div id="chat-wrapper">
                                            <div class="card shadow border-0">
                                                <div class="card-header p-2">
                                                    <div class="d-flex align-items-start">
                                                        <div class="mr-5 d-flex">
                                                            <div class="user-picture background-image d-inline-block" style="background: url('https://www.khaama.com/wp-content/uploads/2019/02/Afghan-Singer-Ghawgha-Taban-880x672-880x672.jpg')">
                                                                <span class="status online"></span>
                                                            </div>
                                                            <div class="user-info d-inline-block">
                                                                <span><?= $geecomDb->contaRigheTabella("geecD_messaggiChat",["idDocumento"=>$documento->getId()]) ?> Messaggi relativi a questo documento</span>
                                                            </div>
                                                        </div>

                                                        <?php 
                                                            if($_SESSION["geecomAdmin_ruolo"]=="super admin" || $documento->getUtente()==$_SESSION["geecomAdmin_id"]) {
                                                                
                                                                ?>
                                                                <div class="azioni btn-group align-self-top">
                                                                    <button type="button" class="btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                          <i class="fas fa-ellipsis-v m-0"></i>
                                                                    </button>
                                                                    <div class="dropdown-menu dropdown-menu-right">
                                                                        <button class="dropdown-item" type="button" onclick="eliminaMessaggiChat()">Svuota chat</button>
                                                                    </div>
                                                                </div>
                                                                <?php 
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                                <div id="messaggiChat" class="card-body">
                                                    <?php stampaMessaggiChat($geecomDb,$documento->getId(),$_SESSION["geecomAdmin_id"]) ?>
                                                </div>
                                                <div class="card-footer p-0">
                                                    <div class="input-group">
                                                        <textarea name="testo1" id="testoMessaggio" rows="1" placeholder="..." class="flex-fill"></textarea>
                                                        <div class="input-group-append">
                                                            <button class="btn send px-3" type="button" onclick="inserisciMessaggio('../',<?= $documento->getId() ?>)"><i class="far fa-paper-plane"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- /Colonna principale -->
            </div>
        </div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/modalMenuComponenti.php";

        include "include/modal/operazioneCompletata.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>
      
    <div id="modalModificaDocumento" class="modal fade" tabindex="-1" aria-labelledby="aggiungi un componente" aria-hidden="true" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Modifica documento</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form name="formModificaDocumento" action="../controller/controllerDocumenti.php" method="POST">
                        <input type="text" class="d-none" name="operazione" value="<?php echo(isset($documento) ? "modifica" : "crea")?>">
                        <input type="text" class="d-none" name="id" value="<?php echo(isset($documento) ? $documento->getId() : "0")?>">

                        <div class="form-group">
                            <label for="titolo-articolo">Nome</label>
                            <input  type="text" class="form-control" id="titolo-articolo" name="nome" value="<?= $documento->getNome() ?>" placeholder="Nome">
                        </div>

                        <div class="form-group">
                            <label for="titolo-articolo">Descrizione</label>
                            <textarea class="form-control" name="descrizione" rows="2"><?= $documento->getDescrizione() ?></textarea>
                        </div>
                    </form>
                    
                    <hr>
                    <h6><strong>Etichette associate</strong></h6>
                    <div id="divTagArticolo">
                        <?php 
                            $query          = "SELECT * FROM geecD_associazioneEtichetteDocumenti AS at JOIN geecD_etichette AS t ON t.id=at.idEtichetta WHERE idDocumento = {$documento->getId()}";
                            $risTagArticolo = $geecomDb->eseguiQueryLettura($query);
                            if($risTagArticolo->num_rows==0) {
                                echo"<h6 id=\"stringaNessunTag\">Questo documento non è associato a etichette </h6>";
                            }
                            else {
                                while($etichetta = $risTagArticolo->fetch_assoc()) {    
                                    $datiTag = $geecomDb->leggiSIngolaRiga("geecD_etichette",$etichetta["idEtichetta"]);
                                    echo"<div id=\"divEtichetta{$datiTag["id"]}\" class=\"d-inline-block mr-2 mb-2\">
                                        <button type=\"button\" class=\"btn btn-primary btn-sm round\" onclick=\"eliminaAssociazioneEtichettaDocumento({$datiTag["id"]})\">{$datiTag["nome"]}<i class=\"fas fa-times ml-2\"></i></button>
                                    </div>";
                                }
                            }
                        ?>
                    </div>

                    <hr>
                    <?php 
                        $queryTagPopolari = "SELECT t.* FROM `geecD_etichette` AS t ORDER BY (SELECT COUNT(*) FROM geecD_associazioneEtichetteDocumenti WHERE idEtichetta = t.id) DESC LIMIT 20";
                        $risTagPopolari   = $geecomDb->eseguiQueryLettura($queryTagPopolari);

                        if($risTagPopolari->num_rows) {
                            ?>
                            <div class="mb-3">
                                <h6><strong>Seleziona tra le etichete più popolari</strong></h6>
                                <?php
                                    while($etichetta = $risTagPopolari->fetch_assoc()) {
                                        echo"<div id=\"divTag{$etichetta["id"]}\" class=\"d-inline-block mr-2 mb-2\">
                                            <button type=\"button\" class=\"btn btn-outline-primary btn-sm round\" onclick=\"associaEtichettaDocumento({$etichetta["id"]},{$documento->getId()})\">{$etichetta["nome"]}<i class=\"fas fa-plus ml-2\"></i></button>
                                        </div>";
                                    }
                                ?>
                            </div>
                            <?php
                        }
                    ?>

                    <h6><strong>Seleziona tra le etichette esistenti</strong></h6>
                    <form name="formTagDaAggiungere" action="../controller/controllerDocumenti.php" method="post">
                        <input type="text" class="d-none" name="operazione" value="associaDocumentoAPiuEtichette">
                        <input type="text" class="d-none" name="id" value=" <?= $documento->getId(); ?>">

                        <div id="divSelectTag" class="input-group mb-3" >
                            <select name="etichetteDaAggiungere[]" class="selectpicker" data-live-search="true" data-size="10" multiple>
                                    <?php 
                                        $query   = "SELECT * FROM geecD_etichette WHERE id NOT IN (SELECT idEtichetta FROM geecD_associazioneEtichetteDocumenti WHERE idDocumento={$documento->getId()}) ORDER BY id";
                                        $risTag  = $geecomDb->eseguiQueryLettura($query);
                                        while($etichetta = $risTag->fetch_assoc()) {
                                            echo"<option value=\"{$etichetta["id"]}\">{$etichetta["nome"]}</option>";
                                        }
                                    ?>
                            </select>
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-primary"><i class="fas fa-plus mr-2"></i>Aggiungi</button>
                            </div>
                        </div>
                    </form>

                    <h6><strong>Crea una nuova etichetta</strong></h6>
                    <div class="input-group">
                        <input id="nuovaEtichettaDocumento" class="form-control form-control" type="text">
                        <div class="input-group-append">
                            <button type="button" class="btn btn-primary" onclick="aggiungiNuovaEtichettaDocumento(<?= $documento->getId() ?>)"><i class="fas fa-plus mr-2"></i>Crea</button>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Chiudi</button>
                    <button type="button" class="btn btn-primary btn-sm" onclick="document.formModificaDocumento.submit()"><i class="fas fa-check mr-2"></i>Salva</button>                    
                </div>
            </div>
        </div>
    </div>
      
    <div class="modal fade" id="modalEliminaElemento" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Eliminare questa versione?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex flex-row justify-content-center">
                        <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                        <div class="align-self-center text-center">
                            <span class="align-self-center text-primary"><em id="nomeVersioneDaEliminare"></em></span>
                            <div id="tipoElementoDaEliminare"></div>
                        </div>
                    </div>
                    <input type="text" class="d-none" id="versioneDaEliminare">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                    <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneVersione()"><i class="fas fa-check"></i> Elimina</button>
                </div>
            </div>
        </div>
    </div>
      
         <div class="modal fade" id="modalEliminaDocumento" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare il documento?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <div class="align-self-center text-center">
                                <span class="align-self-center text-primary"><em id="nomeDocumentoDaEliminare"></em></span>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="documentoDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneDocumentoDaPaginaDettagli()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
      
        <script src="../js/util.js"></script>
        <script>
            function aggiornaComponentiPagina() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerCartelle.php",
                    data:{
                        operazione:"stampaContenutoCartella",
                        id:<?= $documento->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("divContenutoCartella").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function eliminaAssociazioneEtichettaDocumento(idEtichetta) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerDocumenti.php",
                    data:{
                        operazione:"eliminaAssociazioneEtichettaDocumento",
                        id:<?= $documento->getId() ?>,
                        idEtichetta:idEtichetta
                    },
                    success:function(esito) {
                        if(esito=="ok") {   
                            document.getElementById("divEtichetta"+idEtichetta).className = "d-none";
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
                        
            /*
             * questa funzione viene usata per creare un nuovo tag direttamente da
             * questa pagina ed associarlo al documento
             */
            function aggiungiNuovaEtichettaDocumento(idDocumento) {
               var nome = $('#nuovaEtichettaDocumento').val();
               if(nome=="") {
                   alert("Inserisci il nome del tag");
               }
               else {
                   $.ajax({
                        type:"POST",
                        url:"../controller/controllerEtichette.php",
                        data:{
                            operazione:"creaDaPaginaDettagliDocumento",
                            nome:nome,
                            idDocumento:idDocumento
                        },
                        success:function(codice) {
                            if(codice=="L'etichetta che vuoi inserire esiste già") {
                                alert(codice);
                            }
                            else {
                                var vecchioCodice = $("#divTagArticolo").html();
                                $("#divTagArticolo").html(vecchioCodice+codice);
                                var stringaNessunTag = document.getElementById("stringaNessunTag");
                                if(stringaNessunTag!=undefined) {
                                    stringaNessunTag.className = "d-none";
                                }
                                $('#nuovaEtichettaDocumento').val("");
                            }
                        },
                        error: function() {
                           alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                        }
                    });
                }
            }
            
            function eliminaVersione(id,nomeElemento) {
                $('#versioneDaEliminare').val(id);
                $('#nomeVersioneDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneVersione() {
                var id = $('#versioneDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerDocumenti.php",
                    data:{
                        operazione:"eliminaVersione",
                        id:<?= $documento->getId() ?>,
                        idVersione:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("rigaVersione"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            /*
             * questa funzione viene usata solo nella pagina dettagliDocumento.php e differisce dalla sua omologa
             * usata ovunque per il fatto che quando il documento viene cancellato rimanda alla cartella che lo conteneva
             */
            function eseguiEliminazioneDocumentoDaPaginaDettagli() {
                var id = document.getElementById("documentoDaEliminare").value;

                $.ajax({
                    type:"POST",
                    url:"../controller/controllerDocumenti.php",
                    data:{
                        operazione:"elimina",
                        id:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            location.href='dettagliCartella.php?id=<?= $documento->getCartella() ?>&status=220';
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function eliminaMessaggiChat() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerDocumenti.php",
                    data:{
                        operazione:"eliminaMessaggiChat",
                        id:<?= $documento->getId() ?>
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivMessaggi("../",<?= $documento->getId() ?>);
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
      </script>
      
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script>
        <script>
            $(".singolo-file").dropzone({
                acceptedFiles: ".pdf,.doc,.docx,.odt,.ppt,.pptx,.odp,.xls,.xlsx,.ods,.jpeg,.jpg,.png,.gif,.svg,.mp3,.mp4,.zip,.p7m",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    if(response=="ok") {
                        location.reload();
                    }
                    else {
                        alert(response);
                    }
                },
                params:{
                    operazione:"aggiungiVersione",
                    id:<?= $documento->getId() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            });  	
        </script>
  </body>
</html>
